unit DataModule;

interface

uses
  SysUtils, Classes, DB, ADODB, DBXpress, SqlExpr, FMTBcd, DBClient,
  Provider, DBTables;

type
  TDM = class(TDataModule)
    dsTOsoby: TDataSource;
    Database: TDatabase;
    TableOsoby: TTable;
    TableOsobyIDOSOBY: TIntegerField;
    TableOsobyNAZWISKO: TStringField;
    TableOsobyIMIE: TStringField;
    TableOsobyDATAUR: TDateTimeField;
    TableOsobyMCOWOSC: TStringField;
    TableOsobyULICAINR: TStringField;
    TableOsobyKODP: TStringField;
    TableOsobyMIASTO: TStringField;
    TableOsobyPESEL: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure DataModuleDestroy(Sender: TObject);
    procedure TableOsobyFilterRecord(DataSet: TDataSet; var Accept: Boolean);

  private
    filtr : String;

  public
    procedure set_filtr(ss: String);
  end;

var
  DM: TDM;

implementation
{$R *.dfm}
{------------------------------------------------------------------------------}
procedure TDM.set_filtr(ss: String);
begin
   filtr := ss;
end;

procedure TDM.DataModuleCreate(Sender: TObject);
begin
   TableOsoby.Close();
   TableOsoby.IndexName := '';

   Set_filtr('%');
   TableOsoby.Filtered := False;
   Database.Connected  := true;
   TableOsoby.Open();
end;

procedure TDM.DataModuleDestroy(Sender: TObject);
begin
   TableOsoby.Close();
   Database.Connected := false;
end;

procedure TDM.TableOsobyFilterRecord(DataSet: TDataSet; var Accept: Boolean);
var
   s : String;

begin
   s := Trim(DataSet['NAZWISKO']);
   Accept := s = filtr;
end;

end.

